unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, StdCtrls;

type
  TMainForm = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblWYNIK: TLabel;
    MainMenu1: TMainMenu;
    Akcja1: TMenuItem;
    Koniecpracy1: TMenuItem;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure Koniecpracy1Click(Sender: TObject);

  private
	 procedure MyOnKeyPress(Sender: TObject; var Key: Char);
	 procedure MyOnExit(Sender: TObject);
	 procedure Oblicz();
    	
  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.MyOnKeyPress(Sender: TObject; var Key: Char);
var
   warunek : Boolean;

begin
	// dopuszczamy tylko znaki 0..9, znak Del i Backspace
	warunek := ((Key > '0') and (Key < '9')) or (Key = CHR(VK_BACK)) or (Key = CHR(VK_DELETE));

	if warunek then
   begin
		// na razie brak akcji
   end
   else begin
      // ignorujemy wprowadzony znak
		Key := CHR(0);
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Edit1.OnKeyPress := MyOnKeyPress;
   Edit2.OnKeyPress := MyOnKeyPress;
   Edit1.OnExit     := MyOnExit;
   Edit2.OnExit     := MyOnExit;

	Edit1.Text := '0';
	Edit2.Text := '0';
end;

procedure TMainForm.Koniecpracy1Click(Sender: TObject);
begin
	if Application.MessageBox('Koniec pracy?', 'Uwaga', MB_YESNO or MB_ICONQUESTION) = mrYes then
   begin
		Close();
   end
end;

procedure TMainForm.MyOnExit(Sender: TObject);
var
   s1    : String;
   s2    : String;
   s     : String;
   i1    : Integer;
   i2    : Integer;
   wynik : Integer;

begin
   lblWYNIK.Caption := '';

   s1 := Trim(Edit1.Text);
   if s1 = '' then
   begin
   	s1 := '0';
		Edit1.Text := s1;
   end;

   s2 := Trim(Edit2.Text);
   if s2 = '' then
   begin
   	s2 := '0';
		Edit2.Text := s1;
   end;

   i1 := StrToIntDef(s1, 0);
   i2 := StrToIntDef(s2, 0);

   wynik := i1 * i2;
   s := IntToStr(wynik);
   lblWYNIK.Caption := s;
end;

procedure TMainForm.Oblicz();
var
	sa     : String;
	sb     : String;
	a      : Integer;
   b      : Integer;
	wynik  : Integer;

begin
	wynik := 0;
	sa    := '';
	sb    := '';
	a     := 0;
	b     := 0;

   a := StrToIntDef(Edit1.Text, 0);
   b := StrToIntDef(Edit2.Text, 0);

   Edit1.Text := IntToStr(a);
   Edit2.Text := IntToStr(b);

   wynik := a * b;

   lblWYNIK.Caption := IntToStr(wynik);
end;

end.
